import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:wordpress_app/models/notification_model.dart';
import 'package:wordpress_app/services/app_service.dart';
import 'package:wordpress_app/services/notification_service.dart';
import 'package:wordpress_app/utils/cached_image.dart';
import 'package:wordpress_app/utils/next_screen.dart';

class PostNotificationCard extends StatelessWidget {
  final NotificationModel notificationModel;
  const PostNotificationCard({super.key, required this.notificationModel});

  @override
  Widget build(BuildContext context) {
    final hasThumbnail = notificationModel.thumbnailUrl != null &&
        notificationModel.thumbnailUrl!.isNotEmpty;

    return InkWell(
        child: Container(
            decoration: BoxDecoration(
              color: Theme.of(context).cardColor,
              borderRadius: BorderRadius.circular(5),
            ),
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                if (hasThumbnail)
                  SizedBox(
                    height: 110,
                    width: 110,
                    child: CustomCacheImage(
                      imageUrl: notificationModel.thumbnailUrl!,
                      radius: 5,
                    ),
                  ),
                if (hasThumbnail) const SizedBox(width: 12),
                Expanded(
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      Flexible(
                        child: Text(
                          AppService.getNormalText(
                              notificationModel.body.toString()),
                          maxLines: 3,
                          overflow: TextOverflow.ellipsis,
                          style: Theme.of(context)
                              .textTheme
                              .headlineSmall
                              ?.copyWith(
                                fontWeight: FontWeight.w600,
                                fontSize: 17,
                              ),
                        ),
                      ),
                      const SizedBox(height: 8),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          Row(
                            mainAxisSize: MainAxisSize.min,
                            children: [
                              Icon(
                                CupertinoIcons.time,
                                size: 14,
                                color: Theme.of(context)
                                    .colorScheme
                                    .onSurfaceVariant,
                              ),
                              const SizedBox(width: 4),
                              Flexible(
                                child: Text(
                                  AppService.getTime(
                                      notificationModel.date!, context),
                                  maxLines: 1,
                                  overflow: TextOverflow.ellipsis,
                                  style: TextStyle(
                                    fontSize: 12,
                                    color: Theme.of(context)
                                        .colorScheme
                                        .onSurfaceVariant,
                                  ),
                                ),
                              ),
                            ],
                          ),
                          IconButton(
                            padding: EdgeInsets.zero,
                            constraints: const BoxConstraints(
                              minWidth: 32,
                              minHeight: 32,
                            ),
                            icon: const Icon(Icons.close, size: 18),
                            color:
                                Theme.of(context).colorScheme.onSurfaceVariant,
                            onPressed: () => NotificationService()
                                .deleteNotificationData(notificationModel.id),
                          ),
                        ],
                      ),
                    ],
                  ),
                ),
              ],
            )),
        onTap: () =>
            navigateToNotificationDetailsScreen(context, notificationModel));
  }
}
